/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.SummonEventGetter;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class SummonAidRule
extends RuleBase<SummonEventGetter> {
    public static final IEventQuery<ZombieEvent.SummonAidEvent> EVENT_QUERY = new IEventQuery<ZombieEvent.SummonAidEvent>(){

        public World getWorld(ZombieEvent.SummonAidEvent o) {
            return o.getWorld();
        }

        @Override
        public BlockPos getPos(ZombieEvent.SummonAidEvent o) {
            return new BlockPos(o.getX(), o.getY(), o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(ZombieEvent.SummonAidEvent o) {
            return new BlockPos(o.getX(), o.getY() - 1, o.getZ());
        }

        @Override
        public int getY(ZombieEvent.SummonAidEvent o) {
            return o.getY();
        }

        @Override
        public Entity getEntity(ZombieEvent.SummonAidEvent o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(ZombieEvent.SummonAidEvent o) {
            return null;
        }

        @Override
        public Entity getAttacker(ZombieEvent.SummonAidEvent o) {
            return null;
        }

        @Override
        public PlayerEntity getPlayer(ZombieEvent.SummonAidEvent o) {
            return null;
        }

        @Override
        public ItemStack getItem(ZombieEvent.SummonAidEvent o) {
            return ItemStack.field_190927_a;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private static Random rnd = new Random();
    private final GenericRuleEvaluator ruleEvaluator;
    private final Set<String> phases;
    private Event.Result result;

    private SummonAidRule(AttributeMap map, Set<String> phases) {
        super(InControl.setup.getLogger());
        this.phases = phases;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public static SummonAidRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        return new SummonAidRule(map, PhaseTools.getPhases(element));
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        String br;
        super.addActions(map, layer);
        this.result = map.has(RuleKeys.ACTION_RESULT) ? ("default".equals(br = (String)map.get(RuleKeys.ACTION_RESULT)) || br.startsWith("def") ? Event.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? Event.Result.ALLOW : Event.Result.DENY)) : Event.Result.DEFAULT;
        if (map.has(RuleKeys.ACTION_ANGRY)) {
            this.addAngryAction(map);
        }
        if (map.has(RuleKeys.ACTION_HELDITEM)) {
            this.addHeldItem(map);
        }
        if (map.has(RuleKeys.ACTION_ARMORBOOTS)) {
            this.addArmorItem(map, RuleKeys.ACTION_ARMORBOOTS, EquipmentSlotType.FEET);
        }
        if (map.has(RuleKeys.ACTION_ARMORLEGS)) {
            this.addArmorItem(map, RuleKeys.ACTION_ARMORLEGS, EquipmentSlotType.LEGS);
        }
        if (map.has(RuleKeys.ACTION_ARMORHELMET)) {
            this.addArmorItem(map, RuleKeys.ACTION_ARMORHELMET, EquipmentSlotType.HEAD);
        }
        if (map.has(RuleKeys.ACTION_ARMORCHEST)) {
            this.addArmorItem(map, RuleKeys.ACTION_ARMORCHEST, EquipmentSlotType.CHEST);
        }
        if (map.has(RuleKeys.ACTION_POTION)) {
            this.addPotionsAction(map);
        }
    }

    private void addPotionsAction(AttributeMap map) {
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (String p : map.getList(RuleKeys.ACTION_POTION)) {
            String[] splitted = StringUtils.split((String)p, (char)',');
            if (splitted == null || splitted.length != 3) {
                InControl.setup.getLogger().log(Level.ERROR, "Bad potion specifier '" + p + "'! Use <potion>,<duration>,<amplifier>");
                continue;
            }
            Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(splitted[0]));
            if (potion == null) {
                InControl.setup.getLogger().log(Level.ERROR, "Can't find potion '" + p + "'!");
                continue;
            }
            int duration = 0;
            int amplifier = 0;
            try {
                duration = Integer.parseInt(splitted[1]);
                amplifier = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException e) {
                InControl.setup.getLogger().log(Level.ERROR, "Bad duration or amplifier integer for '" + p + "'!");
                continue;
            }
            effects.add(new EffectInstance(potion, duration, amplifier));
        }
        if (!effects.isEmpty()) {
            this.actions.add(event -> {
                ZombieEntity living = event.getZombieHelper();
                for (EffectInstance effect : effects) {
                    EffectInstance neweffect = new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c());
                    living.func_195064_c(neweffect);
                }
            });
        }
    }

    private void addArmorItem(AttributeMap map, Key<String> itemKey, EquipmentSlotType slot) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(map.getList(itemKey));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            Pair<Float, ItemStack> pair = items.get(0);
            this.actions.add(event -> {
                ZombieEntity helper = event.getZombieHelper();
                helper.func_184201_a(slot, ((ItemStack)pair.getRight()).func_77946_l());
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item = this.getRandomItem(items, total);
                ZombieEntity helper = event.getZombieHelper();
                helper.func_184201_a(slot, item.func_77946_l());
            });
        }
    }

    private void addHeldItem(AttributeMap map) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(map.getList(RuleKeys.ACTION_HELDITEM));
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            Pair<Float, ItemStack> pair = items.get(0);
            this.actions.add(event -> {
                ZombieEntity helper = event.getZombieHelper();
                helper.func_184611_a(Hand.MAIN_HAND, ((ItemStack)pair.getRight()).func_77946_l());
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item = this.getRandomItem(items, total);
                ZombieEntity helper = event.getZombieHelper();
                helper.func_184611_a(Hand.MAIN_HAND, item.func_77946_l());
            });
        }
    }

    private void addAngryAction(AttributeMap map) {
        if (((Boolean)map.get(RuleKeys.ACTION_ANGRY)).booleanValue()) {
            this.actions.add(event -> {
                ZombieEntity helper = event.getZombieHelper();
                PlayerEntity player = event.getWorld().func_217362_a((Entity)helper, 50.0);
                if (player != null) {
                    helper.func_70624_b((LivingEntity)player);
                }
            });
        }
    }

    private void addHealthAction(AttributeMap map) {
        float m = map.has(RuleKeys.ACTION_HEALTHMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_HEALTHMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_HEALTHADD) ? ((Float)map.get(RuleKeys.ACTION_HEALTHADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            ZombieEntity helper = event.getZombieHelper();
            ModifiableAttributeInstance entityAttribute = helper.func_110148_a(Attributes.field_233818_a_);
            if (entityAttribute != null) {
                double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                entityAttribute.func_111128_a(newMax);
                helper.func_70606_j((float)newMax);
            }
        });
    }

    private void addSpeedAction(AttributeMap map) {
        float m = map.has(RuleKeys.ACTION_SPEEDMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_SPEEDMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_SPEEDADD) ? ((Float)map.get(RuleKeys.ACTION_SPEEDADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            ZombieEntity helper = event.getZombieHelper();
            ModifiableAttributeInstance entityAttribute = helper.func_110148_a(Attributes.field_233821_d_);
            if (entityAttribute != null) {
                double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                entityAttribute.func_111128_a(newMax);
            }
        });
    }

    private void addSizeActions(AttributeMap map) {
        InControl.setup.getLogger().log(Level.WARN, "Mob resizing not implemented yet!");
        float m = map.has(RuleKeys.ACTION_SIZEMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_SIZEMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_SIZEADD) ? ((Float)map.get(RuleKeys.ACTION_SIZEADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            ZombieEntity helper = event.getZombieHelper();
        });
    }

    private void addDamageAction(AttributeMap map) {
        float m = map.has(RuleKeys.ACTION_DAMAGEMULTIPLY) ? ((Float)map.get(RuleKeys.ACTION_DAMAGEMULTIPLY)).floatValue() : 1.0f;
        float a = map.has(RuleKeys.ACTION_DAMAGEADD) ? ((Float)map.get(RuleKeys.ACTION_DAMAGEADD)).floatValue() : 0.0f;
        this.actions.add(event -> {
            ZombieEntity helper = event.getZombieHelper();
            ModifiableAttributeInstance entityAttribute = helper.func_110148_a(Attributes.field_233823_f_);
            if (entityAttribute != null) {
                double newMax = entityAttribute.func_111125_b() * (double)m + (double)a;
                entityAttribute.func_111128_a(newMax);
            }
        });
    }

    public boolean match(ZombieEvent.SummonAidEvent event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public void action(final ZombieEvent.SummonAidEvent event) {
        SummonEventGetter getter = new SummonEventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity() instanceof LivingEntity ? (LivingEntity)event.getEntity() : null;
            }

            @Override
            public PlayerEntity getPlayer() {
                return null;
            }

            public World getWorld() {
                return event.getWorld();
            }

            @Override
            public BlockPos getPosition() {
                return new BlockPos(event.getX(), event.getY(), event.getZ());
            }

            @Override
            public ZombieEntity getZombieHelper() {
                ZombieEntity helper = event.getCustomSummonedAid();
                if (helper == null) {
                    helper = new ZombieEntity(event.getWorld());
                }
                return helper;
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public Event.Result getResult() {
        return this.result;
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINDAYCOUNT)).attribute(Attribute.create(RuleKeys.MAXDAYCOUNT)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.CATEGORY)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create(RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create(RuleKeys.ACTION_ANGRY)).attribute(Attribute.createMulti(RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION));
    }
}

